# Sistem Booking Lapangan Futsal

## Alur Pemrograman

### 1. Alur Booking Regular
```
User -> Pilih Tanggal -> Cek Ketersediaan -> Isi Form Booking -> Upload Bukti -> Admin Konfirmasi
```

### 2. Alur Booking Ekstrakurikuler
```
User -> Pilih Paket -> Pilih Jadwal -> Isi Form -> Upload Bukti -> Admin Konfirmasi
```

### 3. Alur Booking Turnamen
```
User -> Pilih Paket Turnamen -> Pilih Tanggal -> Isi Form -> Upload Bukti -> Admin Konfirmasi
```

## Tabel Entitas

### 1. users
```sql
- id (PK)
- username
- password
- nama
- email
- role (admin/user)
- created_at
```

### 2. lapangan
```sql
- id (PK)
- nama
- harga_per_jam
- status
- keterangan
```

### 3. booking
```sql
- id (PK)
- user_id (FK)
- lapangan_id (FK)
- tanggal_main
- jam_mulai
- jam_selesai
- total_harga
- status_pembayaran
- bukti_pembayaran
- created_at
```

### 4. booking_eskul
```sql
- id (PK)
- user_id (FK)
- lapangan_id (FK)
- paket_id (FK)
- tanggal_mulai
- tanggal_selesai
- total_harga
- status_pembayaran
- bukti_pembayaran
```

### 5. booking_turnamen
```sql
- id (PK)
- user_id (FK)
- lapangan_id (FK)
- paket_id (FK)
- tanggal_mulai
- tanggal_selesai
- total_harga
- status_pembayaran
- bukti_pembayaran
```

## Use Case Diagram

### Aktor
1. User
   - Melihat jadwal lapangan
   - Melakukan booking (regular/eskul/turnamen)
   - Upload bukti pembayaran
   - Melihat riwayat booking

2. Admin
   - Mengelola lapangan
   - Konfirmasi pembayaran
   - Mengelola paket
   - Export data booking
   - Melihat statistik

## Sequence Diagram

### 1. Booking Regular
```
User -> Frontend: Pilih Tanggal
Frontend -> Backend: Cek Ketersediaan
Backend -> Database: Query Jadwal
Database -> Backend: Hasil Query
Backend -> Frontend: Status Ketersediaan
Frontend -> User: Tampilkan Form Booking
User -> Frontend: Isi Form & Upload Bukti
Frontend -> Backend: Simpan Booking
Backend -> Database: Insert Data
Database -> Backend: Konfirmasi
Backend -> Frontend: Notifikasi Sukses
Frontend -> User: Redirect ke Invoice
```

### 2. Konfirmasi Pembayaran
```
Admin -> Frontend: Buka List Booking
Frontend -> Backend: Get Data Booking
Backend -> Database: Query Booking
Database -> Backend: Data Booking
Backend -> Frontend: Tampilkan List
Admin -> Frontend: Klik Konfirmasi
Frontend -> Backend: Update Status
Backend -> Database: Update Data
Database -> Backend: Konfirmasi
Backend -> Frontend: Refresh List
Frontend -> Admin: Notifikasi Sukses
```

## Distribusi Kode

### 1. Backend (PHP) - 70% dari kode
- Operasi database
- Logika bisnis
- Autentikasi
- Penanganan file
- Pemrosesan form

### 2. Frontend (JavaScript) - 20% dari kode
Fitur JavaScript utama:
- Manajemen kalender menggunakan FullCalendar
- Penanganan formulir dan validasi
- Pemilihan slot waktu dinamis
- Jendela modal untuk manajemen paket
- Panggilan AJAX untuk pengecekan jadwal
- Fungsi filter dan ekspor di dashboard admin
- Penampil bukti pembayaran

### 3. HTML/CSS - 10% dari kode
- Layout halaman
- Styling menggunakan Tailwind CSS
- Desain responsif

## Detail Penggunaan JavaScript

### 1. Halaman Utama (index.php)
```javascript
// Fungsi kalender dan booking
- showBookingDetails() // Menampilkan detail booking
- initializeCalendar() // Inisialisasi kalender
- handleDateClick()    // Menangani klik tanggal
```

### 2. Admin Dashboard (admin/index.php)
```javascript
// Fungsi filter dan modal
- filterBookings()     // Filter booking berdasarkan bulan/tahun
- exportExcel()        // Ekspor data ke Excel
- showPaymentProof()   // Menampilkan bukti pembayaran
```

### 3. Manajemen Lapangan (admin/lapangan.php)
```javascript
// Fungsi pengelolaan lapangan
- showEditModal()      // Modal edit lapangan
- showAddModal()       // Modal tambah lapangan
- deleteField()        // Hapus lapangan
```

### 4. Booking Form (booking.php)
```javascript
// Fungsi form booking
- updateTimeSlots()    // Update slot waktu yang tersedia
- validateForm()       // Validasi form booking
- calculatePrice()     // Hitung harga booking
```

### 5. Jadwal (lihat_jadwal.php)
```javascript
// Fungsi cek jadwal
- loadJadwal()         // Muat jadwal lapangan
- checkAvailability()  // Cek ketersediaan lapangan
```

## Library JavaScript yang Digunakan

1. FullCalendar
   - Digunakan untuk visualisasi kalender
   - Pengelolaan jadwal booking
   - File: assets/js/calendar.js

2. Tailwind CSS (via CDN)
   - Framework CSS untuk styling
   - Komponen UI responsif
   - Versi: 2.2.19

3. Font Awesome
   - Ikon dan elemen visual
   - Versi: 6.0.0-beta3

## Instalasi dan Setup

### Persyaratan Sistem
- PHP 7.4 atau lebih tinggi
- MySQL 5.7 atau lebih tinggi
- Web Server (Apache/Nginx)
- XAMPP (disarankan untuk pengembangan lokal)

### Langkah Instalasi
1. Clone repositori ini ke direktori web server Anda:
   ```bash
   git clone [url-repo] /path/to/xampp/htdocs/mail
   ```

2. Import database:
   - Buka phpMyAdmin
   - Buat database baru bernama 'futsaldot'
   - Import file 'futsaldot.sql'

3. Konfigurasi koneksi database:
   - Buka file 'includes/config.php'
   - Sesuaikan pengaturan koneksi database:
     ```php
     $host = 'localhost';
     $user = 'root';
     $pass = '';
     $db   = 'futsaldot';
     ```

4. Pengaturan folder upload:
   - Buat folder 'uploads/bukti_pembayaran'
   - Pastikan folder memiliki izin write (777)

### Akses Aplikasi
- Frontend: http://localhost/mail/po/
- Admin: http://localhost/mail/po/admin/
- Login admin default:
  - Username: admin
  - Password: admin123

## Struktur Direktori

```
po/
├── admin/              # Area admin
│   ├── includes/       # Komponen admin
│   └── index.php      # Dashboard admin
├── includes/          # Komponen shared
├── uploads/          # File upload
└── index.php         # Halaman utama
```

## Pemeliharaan
- Backup database secara berkala
- Periksa folder uploads secara rutin
- Monitor log error PHP
- Update library JavaScript jika ada versi baru
