<?php
require_once '../config/database.php';
require_once '../includes/functions.php';

// Cek session admin
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header('Location: ../login.php');
    exit();
}

$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $about = mysqli_real_escape_string($conn, $_POST['about']);
    $q = "UPDATE site_content SET value='$about' WHERE `key`='about'";
    if (!mysqli_query($conn, $q)) {
        $msg = '<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-2 rounded mb-4">Gagal update: '.mysqli_error($conn).'</div>';
    } else {
        $msg = '<div class="bg-green-100 border border-green-400 text-green-700 px-4 py-2 rounded mb-4">Berhasil update Tentang Kami!</div>';
    }
}
$res = mysqli_query($conn, "SELECT value FROM site_content WHERE `key` = 'about'");
$row = mysqli_fetch_assoc($res);
$about = $row ? $row['value'] : '';
include '../includes/header.php';
?>
<div class="container mx-auto px-4 py-8 max-w-2xl">
    <h2 class="text-2xl font-bold text-green-700 mb-4">Edit Tentang Kami</h2>
    <?php echo $msg; ?>
    <form method="POST">
        <textarea name="about" rows="8" class="w-full border rounded p-2 mb-4"><?php echo htmlspecialchars($about); ?></textarea>
        <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded">Simpan</button>
    </form>
</div>
<?php include '../includes/footer.php'; ?> 